<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CACL {
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $acl;
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $superadmin = false;
	var $viewonly = false;
	
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __construct() {
		$this->name = "acl";
	}

	public static function newInstance() {
		return new self();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setACL($acl) {

		if (($acl == "superadmin") ||($acl == "viewonly")) {
			$this->superadmin = true;

			if ($acl == "viewonly") {
				$this->viewonly = true;
			}
			
		} elseif (is_array($acl)) {
			foreach ($acl as $key => $val) {
				$this->acl[$val["mod"]][$val["code"]] = true;
			}
		}
	
		return $this;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function checkRule($_rule , $debug = false) {
		global $_USER;

		if ($this->superadmin) {
			return true;
		}				

		if ($_rule == "superadmin") {
			if ($this->superadmin) {
				return true;
			} else {
				return false;
			}
		}
		

		if (stristr($_rule , ",")) {
			$rules = explode("," , $_rule);
		} else {
			$rules = array($_rule);
		}

		foreach ($rules as $key => $val) {
			$tmp = explode(":" , $val);

			if ($debug) {
				debug($tmp);
			}
			
			//check against any rule
			if (trim($tmp["1"]) == "*") {

				if (is_array($this->acl[$tmp[0]])) {
					return true;
				}				
			} elseif (is_array($this->acl[$tmp[0]]) && $this->acl[$tmp[0]][$tmp[1]] ) {
				return true;
			}
			
		}

		
		return false;
				
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function checkModRule($mod , $_rule) {

		if ($this->superadmin) {
			return true;
		}

		if ($_rule == "superadmin") {
			if ($this->superadmin) {
				return true;
			} else {
				return false;
			}
		}


		if (stristr($_rule , ",")) {
			$rules = explode("," , $_rule);
		} else {
			$rules = array($_rule);
		}

		
		foreach ($rules as $key => $rule) {

			if ($rule == "*") {
				return true;
			}
			

			//check if this rule has the module hardcoded in it
			if (stristr($rule , ":")) {
				$tmp = explode(":" , $rule);

				if ($this->acl[$tmp[0]][$tmp[1]]) {
					return true;
				}

			} elseif ($mod["mod_id"]) {

				if ($this->acl[$mod["mod_id"]][$rule] || $this->acl[$mod["mod_module_code"]][$rule] ) {
					return true;
				}
				
			} elseif ($this->acl[$mod["module_code"]][$rule]) {
				return true;
			} 
		}

		return false;

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function deniedAccess() {
		return CSqlAdmin::denyAccess();
	}
	
	
}


?>